<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Stacked Bar 100% Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints1 = array( 
        array("label" => "Facebook",  "y" => 50 ),
        array("label" => "YouTube", "y" => 28 ),
        array("label" => "Google+", "y" => 25 ),
        array("label" => "Twitter",  "y" => 27 ),
        array("label" => "Instagram", "y" => 24 ),
        array("label" => "Tumblr",  "y" => 15 ),
        array("label" => "LinkedIn",  "y" => 13 ),
        array("label" => "Pinterest",  "y" => 14 )
    );
    
    $dataPoints2 = array( 
        array("label" => "Facebook",  "y" => 25 ),
        array("label" => "YouTube", "y" => 30 ),
        array("label" => "Google+", "y" => 28 ),
        array("label" => "Twitter",  "y" => 24 ),
        array("label" => "Instagram", "y" => 23 ),
        array("label" => "Tumblr",  "y" => 18 ),
        array("label" => "LinkedIn",  "y" => 22 ),
        array("label" => "Pinterest",  "y" => 20 )
    );
    
    $dataPoints3 = array( 
        array("label" => "Facebook",  "y" => 13 ),
        array("label" => "YouTube", "y" => 25 ),
        array("label" => "Google+", "y" => 22 ),
        array("label" => "Twitter",  "y" => 24 ),
        array("label" => "Instagram", "y" => 23 ),
        array("label" => "Tumblr",  "y" => 22 ),
        array("label" => "LinkedIn",  "y" => 30 ),
        array("label" => "Pinterest",  "y" => 23 )
    );
    
    $dataPoints4 = array( 
        array("label" => "Facebook",  "y" => 12 ),
        array("label" => "YouTube", "y" => 17 ),
        array("label" => "Google+", "y" => 25 ),
        array("label" => "Twitter",  "y" => 25 ),
        array("label" => "Instagram", "y" => 30 ),
        array("label" => "Tumblr",  "y" => 45 ),
        array("label" => "LinkedIn",  "y" => 35 ),
        array("label" => "Pinterest",  "y" => 43 )
    );
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            title: {
                text: "Social Media Engagement"
            },
            toolTip: {
                shared: true
            },
            axisY: {
                title: "Percentage of Users",
                suffix: "%"
            },
            data: [{
                type: "stackedBar100",
                name: "More than Once a day",
                yValueFormatString: "#,##0\"%\"",
                dataPoints: <?php echo json_encode($dataPoints1, JSON_NUMERIC_CHECK); ?>
            },{
                type: "stackedBar100",
                yValueFormatString: "#,##0\"%\"",
                name: "Daily",
                dataPoints: <?php echo json_encode($dataPoints2, JSON_NUMERIC_CHECK); ?>
            },{
                type: "stackedBar100",
                yValueFormatString: "#,##0\"%\"",
                name: "Weekly",
                dataPoints: <?php echo json_encode($dataPoints3, JSON_NUMERIC_CHECK); ?>
            },{
                type: "stackedBar100",
                yValueFormatString: "#,##0\"%\"",
                name: "Less Often",
                dataPoints: <?php echo json_encode($dataPoints4, JSON_NUMERIC_CHECK); ?>
            }]
        });

        chart.render();
    }
</script>


<?php include '../footer.php'; ?>